// lib/store.ts
import { combineReducers, configureStore } from "@reduxjs/toolkit";
import authReducer from "../store/authSlice";
import inventoryReducer from "../store/inventorySlice";
import uiReducer from "../store/chatSlice";

// 1. Create root reducer
const rootReducer = combineReducers({
  auth: authReducer,
  inventory: inventoryReducer,
  ui: uiReducer,
});

// 2. Derived RootState
export type RootState = ReturnType<typeof rootReducer>;

// 3. Store factory
export const makeStore = (preloadedState?: Partial<RootState>) => {
  return configureStore({
    reducer: rootReducer,
    preloadedState,
  });
};

// 4. Store types
export type AppStore = ReturnType<typeof makeStore>;
export type AppDispatch = AppStore["dispatch"];
