import { BASE_URL } from "@/constants";

export async function fetchSaveStripe(
  user_id: string,
  token: string,
  amount: number,
  payment_intent_id: string,
) {
  const res = await fetch(
    `${BASE_URL}/api/save-stripe?user_id=${user_id}&amount=${amount}&paymentIntent=${payment_intent_id}`,
    {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        Authorization: `Bearer ${token}`,
      },
    },
  );
    const data = await res.json();
    return data;
}
