import { BASE_URL, forceLogout, parseJsonOrLogout } from "@/constants";

export type SaveOrderPack = {
  id: number;
  name: string;
  price: number;
  image: string;
  qty: number;
};

export type SaveOrderRequest = {
  user_id: string;
  brand: string;
  packs: SaveOrderPack[];
  total: number;
  discount: number;
  token: string;
};

export type SaveOrderResponse = {
  gems: number | undefined;
  coins: number | undefined;
  resp: "success" | "error";
  msg: string;
  balance?: number;
  total?: number;
};

export async function saveOrder(
  payload: SaveOrderRequest,
) {
  const res = await fetch(`${BASE_URL}/api/save-order`, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      Authorization: `Bearer ${payload.token}`,
    },
    body: JSON.stringify(payload),
  });

  return parseJsonOrLogout(res);
}
