// 🌍 API Base URL

import { BASE_URL, forceLogout, parseJsonOrLogout } from "@/constants";

// types can live in same file or a dedicated types file
export type SaveShippingPayload = Record<string, any>;

export interface SaveShippingResponse {
  gems: number | undefined;
  coins: number | undefined;
  msg: string;
  resp: "success" | "error";
  balance?: number;
  message?: string;
  url?: string;
  // add any other fields your backend returns
}

// If BASE_URL is already defined in this file, reuse it.
// Otherwise import it from your config file.
export async function saveShipping(
  userId: string,
  token: string,
  payload: SaveShippingPayload,
) {
  const url = `${BASE_URL}/api/save-shipping?user_id=${encodeURIComponent(
    userId,
  )}`;

  const res = await fetch(url, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      Authorization: `Bearer ${token}`,
    },
    body: JSON.stringify(payload),
  });

  return parseJsonOrLogout(res);
}
