import { BASE_URL, forceLogout, parseJsonOrLogout } from "@/constants";

export async function fetchRewards(userID: any, token: any) {
  const res = await fetch(`${BASE_URL}/api/get-rewards?user_id=${userID}`, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      Authorization: `Bearer ${token}`,
    },
    cache: "no-store",
  });

  return parseJsonOrLogout(res);
}

export async function fetchRewardPacks(userID: any, token: any) {
  const res = await fetch(`${BASE_URL}/api/rewards-packs?user_id=${userID}`, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      Authorization: `Bearer ${token}`,
    },
    cache: "no-store",
  });

  return parseJsonOrLogout(res);
}

export async function fetchWeeklyBonus(userID: any, token: any) {
  const res = await fetch(
    `${BASE_URL}/api/rewards-weekly-bonus?user_id=${userID}`,
    {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        Authorization: `Bearer ${token}`,
      },
      cache: "no-store",
    },
  );

  return parseJsonOrLogout(res);
}

export async function fetchReckBack(userID: any, token: any) {
  const res = await fetch(
    `${BASE_URL}/api/rewards-reckback?user_id=${userID}`,
    {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        Authorization: `Bearer ${token}`,
      },
      cache: "no-store",
    },
  );
  const data = await parseJsonOrLogout(res);
  return data;
}
