import { BASE_URL, forceLogout } from "@/constants";

export async function setBalanceMode(user_id: any, token: any, mode: any) {
  const res = await fetch(`${BASE_URL}/api/set-balance-mode`, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      Authorization: `Bearer ${token}`,
    },
    body: JSON.stringify({
      user_id,
      mode,
    }),
  });
  const data = await res.json();
  
  if (!res.ok) {
    forceLogout();

    throw new Error(`Failed to set Balance Mode (${res.status})`);
  }
  return data;
}
