
"use client";

import React, { useState } from "react";
import PrivacyPolicy from "../components/legal/PrivacyPolicy";
import TermsOfService from "../components/legal/TermsOfService";
import CookiesPolicy from "../components/legal/CookiesPolicy";
import AffiliateTerms from "../components/legal/AffiliateTerms";
import DepositBonus from "../components/legal/DepositBonus";
import AmlPolicy from "../components/legal/AmlPolicy";

type LegalTabId =
  | "privacy"
  | "terms"
  | "cookies"
  | "affiliate"
  | "deposit"
  | "aml";

type LegalTab = {
  id: LegalTabId;
  label: string;
};

const TABS: LegalTab[] = [
  { id: "privacy", label: "Privacy Policy" },
  { id: "terms", label: "Terms of Service" },
  { id: "cookies", label: "Cookies" },
  { id: "affiliate", label: "Affiliate Terms" },
  { id: "deposit", label: "Deposit Bonus" },
  { id: "aml", label: "Anti-Money Laundering" },
];

const Inner: React.FC = () => {
  const [activeTab, setActiveTab] = useState<LegalTabId>("privacy");

  const renderContent = () => {
    switch (activeTab) {
      case "privacy":
        return <PrivacyPolicy />;
      case "terms":
        return <TermsOfService />;
      case "cookies":
        return <CookiesPolicy />;
      case "affiliate":
        return <AffiliateTerms />;
      case "deposit":
        return <DepositBonus />;
      case "aml":
        return <AmlPolicy />;
      default:
        return null;
    }
  };

  return (
    <div className="bg-[#05070B] text-white font-onest">
      {/* Main layout */}
      <div className="min-h-[calc(100vh-95px)] flex flex-col md:flex-row">
        {/* Sidebar */}
         <aside className="w-full md:w-64 bg-[#0B1017] border-b md:border-b-0 md:border-r border-[var(--color-gray)] flex-shrink-0 overflow-hidden">
          <div className="px-5 text-sm md:text-xl 2xl:text-2xl font-semibold tracking-wide uppercase text-center py-5 md:py-7 pt-7 md:pt-9 font-sofia">
            TCGWIN LEGAL
          </div>

          <nav className="flex md:flex-col overflow-x-auto md:overflow-visible nice-scrollbar">
            {TABS.map((tab) => {
              const isActive = tab.id === activeTab;
              return (
                <button
                  key={tab.id}
                  onClick={() => setActiveTab(tab.id)}
                  className={`flex-1 mb-4 md:mb-0 md:flex-none whitespace-nowrap w-full text-left px-4 md:px-5 py-2.5 font-medium md:py-3 text-xs md:text-sm transition-colors border-r md:border-r-0 border-b border-[var(--color-gray)] ${
                    isActive
                      ? "bg-[var(--color-gray)] text-white"
                      : "bg-transparent text-[var(--color-slate)] hover:bg-[#111722]"
                  }`}
                >
                  {tab.label}
                </button>
              );
            })}
          </nav>
        </aside>

        {/* Content */}
        <main className="flex-1 py-6 md:py-8 px-4 md:px-6 overflow-y-auto nice-scrollbar">
          {/* Header row */}
          <div className="flex items-center gap-3 md:gap-4 mb-4 md:mb-6">
            <button
              className="cursor-pointer text-xs md:text-sm p-2 px-4 font-extrabold text-white bg-[var(--color-gray)] hover:text-white italic font-sofia transition"
              onClick={() => window.history.back()}
            >
              &lt; Back
            </button>
            <h1 className="text-xs md:text-base uppercase font-extrabold italic tracking-tight">
              {TABS.find((t) => t.id === activeTab)?.label}
            </h1>
          </div>

            <div className="flex-1 overflow-y-auto nice-scrollbar">
            {renderContent()}
          </div>
        </main>
      </div>
    </div>
  );
};

export default Inner;

