export const dynamic = "force-dynamic";
import type { Metadata } from "next";
import { Geist, Geist_Mono, Inter } from "next/font/google";
import "./globals.css";
import { cookies } from "next/headers";
import Header from "./components/Header/Header";
import { ReduxProvider } from "./lib/ReduxProvider";
import LayoutShell from "./components/layout/LayoutShell";

const geistSans = Geist({
  variable: "--font-geist-sans",
  subsets: ["latin"],
});

const geistMono = Geist_Mono({
  variable: "--font-geist-mono",
  subsets: ["latin"],
});

const inter = Inter({
  subsets: ["latin"],
  variable: "--font-inter",
});

export const metadata: Metadata = {
  title: "Create Next App",
  description: "Generated by create next app",
};

export default async function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  const ck = await cookies();
  const cookie = ck.get("session");
  const user = cookie ? JSON.parse(cookie.value) : null;
  return (
    <html lang="en">
      <body
        className={`${geistSans.variable} ${inter.variable} ${geistMono.variable} bg-black antialiased`}
      >
        <ReduxProvider initialUser={user}>
          {/* <Header/> */}

          <LayoutShell>{children}</LayoutShell>
        </ReduxProvider>
      </body>
    </html>
  );
}
