"use client";

import { useState } from "react";

type ToggleProps = {
  checked?: boolean;
  onChange?: (val: boolean) => void;
  className?: string;
};

export default function Toggle({
  checked,
  onChange,
  className = "",
}: ToggleProps) {
  const [internal, setInternal] = useState(false);
  const isOn = checked ?? internal;

  const toggle = () => {
    const next = !isOn;
    setInternal(next);
    onChange?.(next);
  };

  return (
    <button
      type="button"
      role="switch"
      aria-checked={isOn}
      onClick={toggle}
      className={`relative w-[46px] h-[25px] rounded-full
              bg-[#2B5AFF26] shadow-[inset_0_0_0_1px_rgba(255,255,255,0.06)]
              transition-colors duration-300
              ${isOn ? "bg-[#AEAE0F]" : ""} ${className}`}
    >
      {/* subtle outer glow along the track bottom */}
      <span className="pointer-events-none absolute left-1 right-1 bottom-0 h-4 rounded-full bg-black/20 blur-md" />

      {/* knob */}
      <span
        className={`absolute top-1/2 -translate-y-1/2
                w-4 h-4 rounded-full bg-white
                shadow-[0_4px_10px_rgba(0,0,0,0.3)]
                border border-white/70
                transition-[left,box-shadow] duration-300 ease-out
                ${isOn ? "left-[calc(100%-22px)]" : "left-1"}`}
      />
    </button>
  );
}
