"use client";

import { createPortal } from "react-dom";

type AlertModalProps = {
  open: boolean;
  type: "success" | "error";
  message: string | React.ReactNode;
  onClose: () => void;
};

export default function AlertModal({
  open,
  type,
  message,
  onClose,
}: AlertModalProps) {
  if (!open) return null;

  return createPortal(
    <div className="fixed inset-0 !z-9999999999 flex items-center justify-center bg-black/40">
      <div className="bg-(--color-naviBlue) py-3 md:p-6 w-76 md:min-w-120 space-y-4 shadow-xl">
        <h2
          className={`font-onest text-center font-semibold text-lg ${
            type === "success" ? "text-green-600" : "text-red-600"
          }`}
        >
          {type === "success" ? "Success" : "Error"}
        </h2>

        <p className="text-sm uppercase tracking-wide text-white font-bold md:text-2xl text-center">
          {message}
        </p>

        <div className="flex justify-end">
          <button
            onClick={onClose}
            className="px-4 py-1 2xl:py-2 text-sm text-white duration-300 hover:bg-gray-800"
          >
            OK
          </button>
        </div>
      </div>
    </div>,
    document.body,
  );
}
