import { AuthState } from "@/app/wallet/page";
import { getFullImageUrl } from "@/constants";
import Image from "next/image";
import React from "react";
import { useSelector } from "react-redux";
// ---- Card component ----
type TradeCardProps = {
  card: TradeCardItem;
  onClick: () => void;
  isRemoving?: boolean;
  onDelist?: () => void; // 🔹 NEW
  showDelist?: boolean; // 🔹 NEW
};

type TradeCardItem = {
  id: number;
  player: string;
  timeAgo: string;
  rarity: string;
  name: string;
  price: string; // "$11.90"
  image: string;
};
const TradeCard: React.FC<TradeCardProps> = ({
  card,
  onClick,
  isRemoving = false,
  onDelist,
  showDelist = false,
}) => {
  const user = useSelector((state: { auth: AuthState }) => state.auth.user);

  return (
    <div
      onClick={onClick}
      className={`relative group bg-(--color-naviBlue) overflow-hidden cursor-pointer border border-[#151C29] px-4 py-6 flex flex-col items-center duration-300 transtion-all hover:border-[#2B5AFF] transition-all ${
        isRemoving ? "animate-slideOut" : ""
      }`}
      style={{
        animation: isRemoving ? "slideOut 0.5s ease-out forwards" : "none",
      }}
    >
      <div className="absolute bottom-10 left-1/2 -translate-x-1/2 h-0 group-hover:w-44 group-hover:md:h-60 bg-[var(--color-blue)] group-hover:blur-3xl transition-all duration-500 blur-3xl rounded-full opacity-50"></div>

      {/* Top row: avatar, player, time */}
      {/* <div className="flex relative z-20 w-full border-b border-[#29313D] pb-2 items-center justify-between mb-4 text-[10px] md:text-xs font-sofia ">
        <div className="flex items-center gap-2">
          <div className="h-6 w-6 rounded-full overflow-hidden bg-yellow-400 flex items-center justify-center">
            <Image
              src="/images/trade/profile.svg"
              alt={card.player}
              width={24}
              height={24}
              className="object-contain "
            />
          </div>
          <span className="font-extrabold md:text-base ">{card.player}</span>
        </div>
        <span className="text-[var(--color-slate)] md:text-base">
          {card.timeAgo}
        </span>
      </div> */}

      <div className="w-18 relative z-20 h-24 2xl:w-26 2xl:h-38.25">
        <img
          src={`${getFullImageUrl(card.image)}`}
          className="w-full img-border-radius h-full group-hover:rotate-3 transition-all object-cover transform duration-500"
          alt={card.name}
        />
      </div>

      {/* Text under image */}
      <div className="mt-2 relative z-20 text-center">
        <p className="text-[10px] md:text-base font-sofia text-[#DBFAFF] mb-1">
          {card.rarity}
        </p>
        <p className="text-sm md:text-xl font-extrabold font-sofia">
          {card.name.split(" ").slice(0, 2).join(" ")}
        </p>
      </div>

      {/* Price button */}
      <button className="mt-1 rounded-md flex items-center gap-1 bg-[#2B5AFF26] px-6 py-1 text-sm md:text-xl font-extrabold text-[#DBFAFF] font-sofia">
        {!user ? (
          <>
            <img src="/images/header/win.svg" alt="" className="h-4 w-4" />
            {card.price.replace("$", "")}
          </>
        ) : (
          <>
            {user?.activeMode === "coins" ? (
              <img src="/images/header/win.svg" alt="" className="h-4 w-4" />
            ) : (
              <img src="/images/header/star.svg" alt="" className="h-4 w-4" />
            )}{" "}
            {card.price.replace("$", "")}
          </>
        )}
      </button>

      {showDelist && (
        <button
          onClick={(e) => {
            e.stopPropagation(); // card click na chale
            onDelist?.();
          }}
          className="my-2 hover:bg-[var(--color-blue)] cursor-pointer !w-full border border-white text-center py-1"
        >
          DELIST
        </button>
      )}
    </div>
  );
};

export default TradeCard;
