"use client";

import { useEffect, useMemo, useState } from "react";

type Props = {
  onBack: () => void;
  mybets: any; // you can type this better later
};
export default function MyBets({ onBack, mybets }: Props) {
  const [page, setPage] = useState(1);
  const pageSize = 7;

  // ✅ if mybets changes (new fetch), reset page if needed
  useEffect(() => {
    setPage(1);
  }, [mybets?.length]);

  const totalPages = Math.ceil((mybets?.length || 0) / pageSize) || 1;

  const paginatedBets = useMemo(() => {
    const start = (page - 1) * pageSize;
    const end = page * pageSize;
    return (mybets || []).slice(start, end);
  }, [mybets, page]);

  const goToPage = (num: number) => {
    if (num >= 1 && num <= totalPages) setPage(num);
  };
  return (
    <div className="min-h-screen bg-[var(--color-black)] text-white">
      {/* Header */}
      <div className=" z-10">
        <div className="container mx-auto py-4">
          <div className="flex items-center justify-between gap-3">
            <div className="flex items-center gap-4">
              <button
                onClick={onBack}
                className="cursor-pointer text-xs md:text-sm p-2 px-4 font-extrabold text-white bg-[var(--color-gray)] hover:text-white italic font-sofia transition"
              >
                &lt; BACK
              </button>
              <h1 className="text-sm md:text-base font-extrabold italic ">
                MY BETS
              </h1>
            </div>
            <button className="text-xs md:text-sm p-2 px-4 font-extrabold cursor-pointer border border-(--color-blue) bg-[#2B5AFF26] text-white hover:text-white italic font-sofia transition">
              COMPLETED BETS
            </button>
          </div>

          {paginatedBets.map((bet: any, index: number) => {
                let bet_team = null;
                if (bet.bet_team == bet.team_1.id){
                  bet_team = bet.team_1;
                }else if (bet.bet_team == bet.team_2.id){
                  bet_team = bet.team_2;
                }
                return (
                  <div key={index} className="mt-6">
                    <div className="" key={index}>
                    <div className="mt-4">
                      <div className="flex flex-col lg:flex-row gap-3 border py-2 px-4 text-white font-bold text-base md:text-xl 2xl:text-2xl font-sofia  border-[#29313D] bg-[#121924] items-center ">
                        <div className="flex  items-center gap-3">
                          <img src={bet.event_logo} alt="" />
                          <h1>{bet.evetn_id}</h1>
                        </div>
                        <div className="uppercase">
                          {bet.event_title}
                        </div>
                      </div>
                    </div>
                    <div className="flex p-1 px-3 border border-t-0 flex-col lg:flex-row justify-between border-[#29313D] bg-[#161E2A] items-center gap-3 text-white font-bold text-base md:text-2xl 2xl:text-4xl  font-sofia">
                      <div className="flex flex-col md:flex-row flex-1 items-center justify-between gap-2">
                        <div className="flex text-xs md:text-sm text-[#DBFAFF]  flex-col">
                          <div className="flex  items-center gap-5">
                            <h1>{bet.cs_date}</h1>
                            <h1>{bet.cs_time}</h1>
                          </div>
                          <p>
                            {bet.team_1.name} vs {bet.team_2.name}
                          </p>
                        </div>

                        <div className="flex font-onest text-xs md:text-base 2xl:text-lg hover:border-(--color-blue) duration-300 cursor-pointer hover:bg-[#2B5AFF26]  border-2 pl-5 justify-between  gap-4 md:w-[400px] border-(--color-blue) ">
                          <div className="flex items-center gap-2">
                            {/* <img src={bet_team.logo} style={{width:"40px"}}/> */}
                            <h1>{bet_team.name}</h1>
                          </div>
                          {/* <div className="bg-(--color-blue) p-4">3.15</div> */}
                        </div>
                      </div>
                      <div className="flex flex-col md:flex-row flex-1 items-center justify-between gap-2">
                        <div className="flex font-onest text-xs md:text-base 2xl:text-lg duration-300 cursor-pointer pr-5 gap-2 md:w-100  ">
                          {bet.cards.map((card: any, idx: number) => (
                            <div className="flex items-center gap-2" key={idx}>
                              <img
                                src={`/cards/${card.replace(/^\/+/, "")}`}
                                alt=""
                                className="w-12"
                              />
                            </div>
                          ))}
                        </div>
                        <div className="flex items-center gap-2">
                          <button
                            // onClick={(e) => {
                            //   e.preventDefault();
                            //   setShowBetModal(true);
                            // }}
                            className=" bg-[#F14B3F] hover:bg-red-600 cursor-pointer px-6 py-3 font-onest text-xs md:text-sm"
                          >
                            Cancel Bet
                          </button>
                        </div>
                      </div>
                    </div>
                  </div>
                  </div>
                )
            
              })}
          {totalPages > 1 && (
            <div className="flex font-onest justify-center items-center gap-3 m-6">
              <button
                onClick={() => goToPage(page - 1)}
                disabled={page === 1}
                className="rounded-full w-[34px] h-[34px] flex justify-center items-center bg-[var(--color-gray)] hover:bg-[var(--color-gray)] disabled:opacity-40"
              >
                <img src="/images/profile/left.svg" alt="" />
              </button>

              <div className="flex gap-2 text-sm">
                {[...Array(totalPages)].map((_, i) => {
                  const pg = i + 1;

                  if (
                    pg === 1 ||
                    pg === totalPages ||
                    Math.abs(pg - page) <= 1
                  ) {
                    return (
                      <button
                        key={pg}
                        onClick={() => goToPage(pg)}
                        className={`px-3 py-1 rounded ${
                          pg === page
                            ? "scale-115 text-white"
                            : "text-[var(--color-naturalGray)]"
                        }`}
                      >
                        {pg}
                      </button>
                    );
                  }

                  if (pg === page - 2 || pg === page + 2) {
                    return (
                      <span
                        key={`ellipsis-${pg}`}
                        className="px-2 text-gray-400"
                      >
                        ...
                      </span>
                    );
                  }

                  return null;
                })}
              </div>

              <button
                onClick={() => goToPage(page + 1)}
                disabled={page === totalPages}
                className="flex justify-center items-center w-[34px] h-[34px] rounded-full bg-[var(--color-gray)] hover:bg-[var(--color-gray)] disabled:opacity-40"
              >
                <img src="/images/profile/right.svg" alt="" />
              </button>
            </div>
          )}
        </div>
      </div>
    </div>
  );
}
