"use client";

import { User } from "@/constants/types";
import Image from "next/image";
import { useSelector } from "react-redux";

type BoxItem = {
  id: number;
  title: string;
  price: string;
  chance: string; // e.g. "0.1%"
  img: string;
};

type BaseCard = {
  id: string | number; // <-- IMPORTANT: supports both
  name: string;
  image: string;
  price?: number;
};
type TCard = BaseCard;

export default function WhatsInsideTheBoxGrid({
  track,
  qty,
}: {
  track: TCard[];
  qty: number;
}) {
  const user = useSelector((state: any) => state.auth.user) as User | null;

  return (
    <div className="w-full bg-[#0b111a] text-white">
      <div className="mx-auto max-w-7xl px-4 py-6">
        <h2 className="mb-4 text-xs font-semibold tracking-widest text-white/90">
          WHATS INSIDE THE BOX
        </h2>

        <div className="grid gap-4 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-6">
          {track.map((item, index) => (
            <div
              key={index}
              className="relative overflow-hidden border border-white/10 "
            >
              {/* Chance pill */}
              <div className="absolute left-2 top-2 z-10 rounded-3xl bg-[#0e1a2c] px-2 py-0.5 text-[10px] font-semibold text-white/90 border border-[#4D4CFE]">
                {qty}
              </div>

              {/* Image */}
              <div className="relative flex h-32.5 items-center justify-center p-2">
                {/* glow */}
                <div className="pointer-events-none absolute inset-0" />
                <Image
                  src={`/cards${
                    item.image?.startsWith("/") ? item.image : `/${item.image}`
                  }`}
                  alt={item.name}
                  width={220}
                  height={220}
                  className="relative z-10 h-27.5 mt-3 w-auto object-contain"
                />
              </div>

              {/* Footer */}
              <div className="bg-blur relative w-full z-10 px-3 -mt-10 pb-4 pt-3 text-center">
                <div className="truncate text-[10px] md:text-sm font-semibold uppercase text-white/90">
                  {item.name}
                </div>
                <div className="mt-1 flex items-center gap-1 justify-center text-[10px] md:text-base font-semibold text-white/80">
                  {!user ? (
                    <img
                      src="/images/header/win.svg"
                      alt=""
                      className="h-4 w-4"
                    />
                  ) : (
                    <>
                      {user?.activeMode === "coins" ? (
                        <img
                          src="/images/header/win.svg"
                          alt=""
                          className="h-4 w-4"
                        />
                      ) : (
                        <img
                          src="/images/header/star.svg"
                          alt=""
                          className="h-4 w-4"
                        />
                      )}
                    </>
                  )}
                  {item.price}
                </div>
              </div>
            </div>
          ))}
        </div>
      </div>
    </div>
  );
}
