import { User } from "@/constants/types";
import React from "react";
import { useSelector } from "react-redux";

type BoxItem = {
  id: number;
  name: string;
  price: string;
  image: string;
};

type BoxLayoutProps = {
  boltMode: boolean;
  selectedMode: number;
  spinning: boolean;

  viewportRef: React.RefObject<HTMLDivElement | null>;

  renderContent: () => React.ReactNode;

  handleOpenBox: () => void;
  handleFreeSpin: () => void;
  handleModeChange: (num: number) => void;
  boxId: any;
  box?: BoxItem;
};

export default function BoxLayout({
  boltMode,
  selectedMode,
  spinning,
  viewportRef,
  renderContent,
  handleOpenBox,
  handleFreeSpin,
  handleModeChange,
  boxId,
  box,
}: BoxLayoutProps) {
  // const lockedMode = boxId ? Number(boxId) : null;
  // const isLocked =
  //   Number.isFinite(lockedMode) && lockedMode! >= 1 && lockedMode! <= 6;
  const user = useSelector((state: any) => state.auth.user) as User | null;

  return (
    <div
      className="mb-10 2xl:mb-16 light-black-bg text-white"
      style={{
        ["--speed-accel" as any]: boltMode ? "0.3s" : "1s",
        ["--speed-fast" as any]: boltMode ? "0.4s" : "0.45s",
        ["--speed-slow" as any]: boltMode ? "0.6s" : "1s",
        ["--speed-slower" as any]: boltMode ? "0.9s" : "2s",
        ["--speed-slowest" as any]: boltMode ? "1.4s" : "5s",

        ["--speed-accel-v" as any]: boltMode ? "0.3s" : "1s",
        ["--speed-fast-v" as any]: boltMode ? "0.4s" : "0.45s",
        ["--speed-slow-v" as any]: boltMode ? "0.6s" : "1s",
        ["--speed-slower-v" as any]: boltMode ? "0.9s" : "2s",
        ["--speed-slowest-v" as any]: boltMode ? "1.4s" : "5s",
      }}
    >
      <div className="container mx-auto">
        <div className="bg relative">
          <h1 className="p-2 text-xs z-20 md:text-sm font-bold font-onest md:px-8 w-fit absolute top-3 right-0 text-right">
            PROVABLY FAIR
          </h1>

          <div
            className={`relative mb-8 rounded-lg ${
              selectedMode === 1 ? "p-4 md:p-8 " : ""
            } min-h-87.5 md:min-h-100 flex items-center justify-center overflow-hidden`}
          >
            {selectedMode === 1 && (
              <div className="absolute bottom-17 left-1/2 -translate-x-1/2 w-20 md:w-55 h-32.5 md:h-62.5 bg-(--color-blue) blur-3xl rounded-full opacity-50" />
            )}

            <div
              ref={viewportRef}
              className={`relative w-full ${
                selectedMode === 1 ? "h-67.5 max-w-5xl" : "h-full"
              } pt-4 overflow-hidden`}
            >
              {selectedMode === 1 ? (
                <>
                  <div className="pointer-events-none absolute inset-y-0 z-10 left-0 w-20 md:w-40 !bg-linear-to-r !from-[var(--color-naviBlue)] !via-[var(--color-naviBlue)]/80 !to-transparent" />
                  <div className="pointer-events-none absolute inset-y-0 z-10 right-0 w-20 md:w-40 !bg-gradient-to-l !from-[var(--color-naviBlue)] !via-[var(--color-naviBlue)]/80 !to-transparent" />
                </>
              ) : (
                <>
                  <div className="pointer-events-none absolute inset-x-0 z-10 top-0 h-15 !bg-gradient-to-b !from-[var(--color-naviBlue)] !via-[var(--color-naviBlue)]/80 !to-transparent" />
                  <div className="pointer-events-none absolute inset-x-0 z-10 bottom-0 h-15 !bg-gradient-to-t !from-[var(--color-naviBlue)] !via-[var(--color-naviBlue)]/80 !to-transparent" />
                </>
              )}

              {renderContent()}
            </div>
          </div>
        </div>

        <div className="flex font-onest px-5 md:px-0 items-center flex-col md:flex-row gap-4 justify-between">
          <div className="flex gap-4">
            <button
              // onClick={handleOpenBox}
              onClick={handleFreeSpin}
              className="md:px-8 px-4 py-2 md:py-3 bg-(--color-blue) text-xs font-onset hover:bg-blue-900 text-white rounded transition tracking-tighter md:text-base 2xl:text-lg"
            >
              {spinning ? (
                "SPINNING"
              ) : (
                <>
                  <span className="flex items-center gap-1 font-extrabold">
                  OPEN BOX 
                    {!user ? (
                      <img
                        src="/images/header/win.svg"
                        alt=""
                        className="h-4 w-4"
                      />
                    ) : (
                      <>
                        {user?.activeMode === "coins" ? (
                          <img
                            src="/images/header/win.svg"
                            alt=""
                            className="h-4 w-4"
                          />
                        ) : (
                          <img
                            src="/images/header/star.svg"
                            alt=""
                            className="h-4 w-4"
                          />
                        )}
                      </>
                    )}
                    {box?.price}
                  </span>
                </>
              )}
            </button>

            {/* <button
              onClick={handleFreeSpin}
              disabled={spinning}
              className={`md:px-8 px-4 py-2 text-xs md:text-base 2xl:text-lg md:py-3 ${
                spinning ? "bg-gray-600" : " hover:bg-gray-700"
              } text-white font-bold rounded transition text-lg border-2 ${
                spinning ? "cursor-not-allowed" : "cursor-pointer"
              }`}
            >
              {spinning ? "SPINNING..." : "FREE SPIN"}
            </button> */}
          </div>

          <div className="flex gap-2">
            {[1, 2, 3, 4, 5, 6].map((num) => {
              // const disabled = isLocked && num !== lockedMode;

              return (
                <button
                  key={num}
                  onClick={() => handleModeChange(num)}
                  // disabled={disabled}
                  className={`w-6 h-6 md:w-11 md:h-11 text-xs font-extrabold md:text-lg rounded
          ${
            num === selectedMode
              ? "bg-white text-(--color-blue)"
              : "text-white border hover:bg-gray-700"
          }
          font-bold transition
          `}
                  // ${
                  //   disabled ? "opacity-40 cursor-not-allowed hover:bg-transparent" : ""
                  // }
                >
                  {num}
                </button>
              );
            })}
          </div>
        </div>
      </div>
    </div>
  );
}
