import Image from "next/image";

type PlayingForBarProps = {
  winnerTier: string;
  players: any[];
};

const tierUI: Record<string, { border: string; text: string; icon: string }> = {
  "tier-2x": {
    border: "border-[#FFAA4A]", // gold
    text: "text-[#FFAA4A]",
    icon: "/images/roll/gold.svg",
  },
  "tier-14x": {
    border: "border-[#137E6A]", // green
    text: "text-[#137E6A]",
    icon: "/images/roll/green.svg",
  },
  "tier-7x": {
    border: "border-[#422C53]", // purple
    text: "text-[#422C53]",
    icon: "/images/roll/purple.svg",
  },
  "tier-2x-red": {
    border: "border-[#D22F31]", // red
    text: "text-[#D22F31]",
    icon: "/images/roll/red.svg",
  },
};

const PlayingForBar: React.FC<PlayingForBarProps> = ({
  winnerTier,
  players,
}) => {
  const allCards = players.flatMap((p) => p.cards || []);
  const totalCards = allCards.length;
  const ui = tierUI[winnerTier] ?? tierUI["tier-2x"];

  return (
    <div className="flex my-5 gap-3 items-center justify-center w-full">
      <div
        className={`min-w-full lg:min-w-225 winnerShadow border ${ui.border} rounded-md px-3 py-2 md:px-6 md:py-3`}
      >
        <div className="flex flex-col md:flex-row items-center gap-4 md:gap-6">
          {/* LEFT */}
          <div className="flex items-center gap-3 pr-4 md:pr-6 border-r border-slate-700/70">
            <span
              className={`${ui.text}  text-base md:text-lg 2xl:text-xl font-semibold font-sofia uppercase`}
            >
              Playing for
            </span>
            <div className="h-10 w-10 md:h-20 md:w-20 flex items-center justify-center shadow-md">
              <Image
                src={ui.icon}
                alt="winner tier icon"
                width={40}
                height={40}
                className="w-full h-full object-contain"
              />
            </div>
          </div>

          {/* RIGHT */}
          <div className="flex-1 flex flex-col md:flex-row items-center">
            <span
              className={`flex-1 ${ui.text} text-center text-base md:text-lg 2xl:text-xl font-semibold font-sofia uppercase`}
            >
              Winner Tier: {winnerTier}
            </span>

            <div className="flex gap-1 md:gap-1.5 justify-end">
              {allCards.slice(0, 10).map((c: any) => (
                <div key={c.inv_id} className="relative aspect-3/4 w-8 md:w-12">
                  <Image
                    src={String(c.image).replace("cardsimages", "cards/images")}
                    alt="card"
                    fill
                    className="img-border-radius object-cover border border-slate-700/80"
                  />
                </div>
              ))}

              {totalCards > 10 && (
                <div className="flex items-center justify-center w-8 md:w-12 text-xs text-white/70">
                  +{totalCards - 10}
                </div>
              )}
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default PlayingForBar;
