"use client";

import Image from "next/image";
import { useEffect, useState } from "react";
import { InternalButton } from "../ui/Button";

type CardDrop = {
  id: number;
  date: string;
  title: string;
  price: string;
  image: string; // image path
};

type Props = {
  card: CardDrop | null;
  onClose: () => void; // parent me setDetailCard(null)
};

export default function ProfileDetailDrawer({ card, onClose }: Props) {
  const [isOpen, setIsOpen] = useState(false);

  // card aaye to drawer open animation
  useEffect(() => {
    if (card) {
      setIsOpen(true);
    }
  }, [card]);

  if (!card) return null;

  const handleClose = () => {
    // slide out
    setIsOpen(false);
    // animation duration (300ms) ke baad parent ko close
    setTimeout(() => {
      onClose();
    }, 300);
  };

  return (
    <div className="fixed inset-0 z-[99998] flex justify-end">
      {/* BACKDROP */}
      <div
        className={`
          flex-1  transition-transform cursor-pointer duration-500 ease-out
          ${isOpen ? " translate-x-0" : " translate-x-100"}
        `}
        onClick={handleClose}
        aria-hidden="true"
      />

      {/* PANEL */}
      <div
        className={`
          relative w-full max-w-md bg-[#10131B] h-full shadow-2xl
          transform transition-transform duration-500 ease-out
          ${isOpen ? "translate-x-0" : "translate-x-full"}
          `}
      >
        {/* back btn */}
        <div className="flex font-sofia mt-7 px-4 items-center gap-3">
          <button
            onClick={handleClose}
            className="self-start text-[10px] cursor-pointer px-3 py-1 bg-[var(--color-gray)] text-white font-bold"
          >
            &lt; BACK
          </button>
          <p>{card.date}</p>
        </div>
        <div className="h-full overflow-y-auto px-6 pt-10 flex flex-col items-center text-center font-sofia">
          {/* big card */}
          <div className="relative mb-6">
            <div className="w-[220px] h-[300px] mx-auto flex items-center justify-center">
              <Image
                src={card.image}
                alt={card.image}
                width={200}
                height={280}
                className="w-[160px] h-[250px] object-contain  rotate-swing"
              />
            </div>
            {/* <div className="absolute -bottom-4 left-1/2 -translate-x-1/2 px-4 py-1 rounded-full text-[#DBFAFF] bg-[#151B27] text-xs md:text-base 2xl:text-xl font-bold">
              card.quantity
            </div> */}
          </div>

          {/* <div className="mt-2 text-xs md:text-base 2xl:text-3xl text-[var(--color-blue)] font-bold uppercase">
            card.rarity
          </div> */}
          <div className="mt-2 text-lg md:text-xl 2xl:text-3xl font-extrabold uppercase">
            {card.title}
          </div>
          <div className="mt-1 text-xl md:text-2xl font-extrabold text-white">
            {card.price}
          </div>

          <InternalButton
            variant="outline"
            className="mt-5 uppercase font-onest !text-[var(--color-blue)] !border-[var(--color-blue)]"
          >
            Delist Card
          </InternalButton>
        </div>
      </div>
      
    </div>
  );
}
