// import React, { useState } from "react";
// interface OrderModalProps {
//   open: boolean;
//   setOpen: (open: boolean) => void;
// }
// interface CardPackOrder {
//   orderId: string;
//   totalCards: number;
//   date: string;
//   status: string;
//   trackingNumber: string;
//   address: string;
//   cards: string[];
// }

// interface JourneyData {
//   title: string;
//   totalCards: number;
//   clientSeed: string;
//   serverSeed: string;
//   nonce: string;
//   date: string;
//   cards: string[];
// }

// const CardPackUI =  ({ open, setOpen }: OrderModalProps) => {
//   const [isJourneyModalOpen, setIsJourneyModalOpen] = useState(false);
//   const [copiedField, setCopiedField] = useState<string | null>(null);

//   // Dummy data for order
//   const orderData: CardPackOrder = {
//     orderId: "2345",
//     totalCards: 120,
//     date: "THURSDAY, DEC 26, 2024",
//     status: "SHIPPED",
//     trackingNumber: "7d31212312",
//     address: "123, XYZ STREET, CALGARY, ALBERTA, CANADA",
//     cards: Array(45).fill("/images/profile/pkimg.svg"),
//   };

//   const copyToClipboard = (text: string, field: string) => {
//     navigator.clipboard.writeText(text);
//     setCopiedField(field);
//     setTimeout(() => setCopiedField(null), 2000);
//   };

//   return (
//     <div className=" p-4 md:p-8 flex items-center justify-center">
//       {/* Demo Buttons */}

//       {/* Order Modal */}
//       {open && (
//         <div className="fixed inset-0 bg-black/70 backdrop-blur-sm z-[9999] flex items-center justify-center p-4 animate-in fade-in duration-200">
//           <div className="w-full max-w-6xl max-h-[90vh]  border border-slate-700 overflow-hidden bg-[#161E2A] flex flex-col animate-in zoom-in-95 duration-200">
//             {/* Header */}
//             <div className=" p-4 pr-0 md:pr-0 md:px-6 relative flex-shrink-0">
//               <div className="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
//                 <div>
//                   <p className="font-onest text-base md:text-xl= mb-1">
//                     ORDER ID{" "}
//                     <span className="font-bold">#{orderData.orderId}</span>
//                   </p>
//                 </div>
//                 <div className="font-sofia p-4 py-2 bg-black text-center">
//                   <p className=" text-base md:text-xl mb-1">TOTAL CARDS</p>
//                   <h1 className="font-bold text-xl md:text-2xl -mt-3 2x:text-4xl">
//                     {" "}
//                     {orderData.totalCards}
//                   </h1>
//                 </div>
//                 <div className=""></div>
//                 <button
//                   onClick={() => setOpen(false)}
//                   className=" absolute right-0 top-4 md:top-4 md:right-0 md:block text-slate-400 hover:text-white transition-colors z-10"
//                 >
//                   <img src="/images/profile/cross.svg" className="p-5  cursor-pointer" alt="" />
//                 </button>
//               </div>
//             </div>

//             {/* Scrollable Content */}
//             <div className="overflow-y-auto nice-scrollbar flex-1 p-6 md:p-8">
//               {/* Cards Grid */}
//               <div className="grid grid-cols-5 sm:grid-cols-8 md:grid-cols-10 lg:grid-cols-15 gap-2 md:gap-3 mb-8">
//                 {orderData.cards.map((card, index) => (
//                   <div
//                     key={index}
//                     className="aspect-[2/3] transition-all duration-300 cursor-pointer relative overflow-hidden"
//                   >
//                     {/* IMAGE */}
//                     <img
//                       src={card}
//                       alt={`Card ${index}`}
//                       className="absolute inset-0 w-full h-full object-cover"
//                     />

//                     {/* OPTIONAL OVERLAY (glow, shine effect) */}
//                     <div className="absolute inset-0 bg-gradient-to-t from-blue-400 to-transparent opacity-20 pointer-events-none"></div>
//                   </div>
//                 ))}
//               </div>
//             </div>
//             {/* Footer Info */}
//             <div className="grid font-sofia bg-[#121924] p-6 grid-cols-1 md:grid-cols-3 gap-4 pt-6 border-t border-slate-700">
//               <p className="text-white font-semibold text-sm md:text-2xl">
//                 {orderData.date}
//               </p>
//               <div className="flex items-center gap-2">
//                 <p className=" font-bold text-sm md:text-2xl">
//                   {orderData.status}
//                 </p>
//                 <p className="font-bold text-sm md:text-2xl">
//                   {" "}
//                   {orderData.trackingNumber}
//                 </p>
//                 <div
//                   className="ml-1 cursor-pointer hover:text-white transition-colors"
//                   onClick={() =>
//                     copyToClipboard(orderData.trackingNumber, "tracking")
//                   }
//                 >
//                   <img src="/images/profile/copy.svg" alt="" className="w-4" />
//                 </div>
//               </div>
//               <div>
//                 <p className="text-white font-semibold text-sm md:text-2xl">
//                   {orderData.address}
//                 </p>
//               </div>
//             </div>
//           </div>
//         </div>
//       )}

//     </div>
//   );
// };

// export default CardPackUI;
import { useState } from "react";
interface OrderModalProps {
  open: boolean;
  setOpen: (open: boolean) => void;
  orderId: number | null;
  shipment: any | null;
  cards: { id: number; image: string }[];
  loading: boolean;
}

const CardPackUI = ({
  open,
  setOpen,
  orderId,
  shipment,
  cards,
  loading,
}: OrderModalProps) => {
  const [copiedField, setCopiedField] = useState<string | null>(null);
  const baseUrl = "https://backend.openthatpack.com";
  const copyToClipboard = (text: string, field: string) => {
    navigator.clipboard.writeText(text);
    setCopiedField(field);
    setTimeout(() => setCopiedField(null), 2000);
  };
  if (!open) return null;

  return (
    <div className="p-4 md:p-8 flex items-center justify-center">
      <div className="fixed inset-0 bg-black/70 backdrop-blur-sm z-[9999] flex items-center justify-center p-4">
        <div className="w-full max-w-6xl max-h-[90vh] border border-slate-700 overflow-hidden bg-[#161E2A] flex flex-col">
          {/* Header */}

          <div className=" p-4  md:px-6 relative flex-shrink-0">
            <div className="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
              <div>
                <p className="font-onest text-base md:text-xl= mb-1">
                  ORDER ID <span className="font-bold">#{orderId}</span>
                </p>
              </div>
              <div className="font-sofia p-4 py-2 bg-black text-center">
                <p className=" text-base md:text-xl mb-1">TOTAL CARDS</p>
                <h1 className="font-bold text-xl md:text-2xl -mt-3 2x:text-4xl">
                  {" "}
                  {shipment.totalCards}
                </h1>
              </div>
              <div className=""></div>
              <button
                onClick={() => setOpen(false)}
                className=" absolute right-0 top-4 md:top-4 md:right-0 md:block text-slate-400 hover:text-white transition-colors z-10"
              >
                <img
                  src="/images/profile/cross.svg"
                  className="p-5  cursor-pointer"
                  alt=""
                />
              </button>
            </div>
          </div>

          {/* Cards */}
          <div className="overflow-y-auto nice-scrollbar flex-1 p-6 md:p-8">
            {loading ? (
              <div className="flex w-full h-[160px] items-center justify-center">
                <div className="w-8 h-8 border-4 border-white/20 border-t-white rounded-full animate-spin" />
              </div>
            ) : (
              <>
                {cards.length === 0 ? (
                  <>
                    <p className="text-xs font-sofia md:text-2xl">
                      No cards found
                    </p>
                  </>
                ) : (
                  <>
                    <div className="grid grid-cols-5 sm:grid-cols-8 md:grid-cols-10 lg:grid-cols-15 gap-2 md:gap-3 mb-8">
                      {cards.map((c, ind) => (
                        <div
                          key={ind}
                          className="aspect-[2/3] cursor-pointer relative overflow-hidden"
                        >
                          <img
                            src={`/cards/${c.image}`} // ✅ because response has "/images/..."
                            alt={`Card ${c.id}`}
                            className="absolute inset-0 w-full h-full object-cover"
                          />
                        </div>
                      ))}
                    </div>
                  </>
                )}
              </>
            )}
          </div>

          {/* Footer */}
          <div className="grid font-sofia bg-[#121924] p-6 grid-cols-1 md:grid-cols-3 gap-4 pt-6 border-t border-slate-700">
            <p className="text-white font-semibold text-sm md:text-2xl">
              {shipment?.date ?? "-"}
            </p>
            <div className="flex items-center justify-center gap-2">
              <p className="font-bold text-sm md:text-2xl">
                {/* {shipment?.status ?? "-"} */}
              </p>
              <p className="font-bold  text-sm md:text-2xl">
                {shipment?.tracking ?? "-"}
              </p>
            </div>
            <div>
              <p className="text-white font-semibold text-sm text-right md:text-2xl">
                {shipment?.address ?? "-"}
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default CardPackUI;
