"use client";
import Link from "next/link";
import { redirect } from "next/navigation";
import { useEffect } from "react";

export default function End({ cards, pack, user_id, mode }) {
  // useEffect(() => {
  //   console.log("pack", pack);
  // }, [pack]);
  function _red() {
    redirect("/new-page");
  }
  const imageSrc =
    pack.image && !["/undefined", "undefined", "null"].includes(pack.image)
      ? `/cards${pack.image}`
      : "/cards/images/packs/destinedrivals.png";

  const IMAGE_BASE_URL = "https://openthatpack.com/";
  return (
    <>
      <div className={mode + " end-card"}>
        <div className="btns">
          <Link
            className="font-onest !hover:bg-transparent text-white bg-[var(--color-naviBlue)] hover:border-white duration-300  border border-transparent"
            href="/inventory"
          >
            Inventory
          </Link>
          <Link
            className="font-onest !hover:bg-transparent text-white bg-[var(--color-naviBlue)] hover:border-white duration-300  border border-transparent"
            href="/shop"
          >
            Shop
          </Link>
        </div>
        {cards.length > 0 ? (
          <div className="card">
            <img
              className=" w-28 md:w-56"
              src={`${IMAGE_BASE_URL}${cards[0].cover_image?.replace(
                /^\/+/,
                ""
              )}`}
            />
          </div>
        ) : null}
        {pack?.id &&
        pack.image &&
        pack.image !== "/undefined" &&
        pack.image !== "undefined" &&
        pack.image !== "" &&
        pack.image !== "null" ? (
          // {pack ? (
          <div className="pack">
            <div>
              <img src={imageSrc} />
            </div>
            <a
              className="font-onest !hover:bg-transparent text-white bg-(--color-naviBlue) hover:border-white duration-300  border border-transparent"
              href={"/inventory/" + pack.brand + "/" + pack.un_id}
            >
              Open Next
            </a>
          </div>
        ) : (
          <div />
        )}
      </div>
    </>
  );
}
