"use client";
import { MysteryPack } from "@/app/games/mystery-packs/Inner";
import { User } from "@/constants/types";
import React from "react";
import { useSelector } from "react-redux";

interface PacksGridProps {
  packs: MysteryPack[];
  isBuying: boolean;
  onView: (pack: MysteryPack) => void;
}

const PacksGrid: React.FC<PacksGridProps> = ({ packs, isBuying, onView }) => {
  const user = useSelector((state: any) => state.auth.user) as User | null;

  return (
    <section className="py-5">
      <div className="grid gap-4 sm:grid-cols-2 lg:grid-cols-4">
        {packs.map((pack) => (
          <div
            key={pack.id}
            className="bg-[#161E2A] border border-[#151C29] shadow-lg flex flex-col items-center justify-between w-full px-6 pt-6 pb-5 text-white"
          >
            <div className="w-full flex justify-center -mb-4">
              <img
                src={pack.image}
                alt={pack.title}
                className="h-32 md:h-56 2xl:h-60 w-auto object-contain"
              />
            </div>

            <div className="bg-[#161E2A]/70 backdrop-blur-md w-full">
              <div className="w-full pt-3 text-center">
                <p className="text-base md:text-xl font-extrabold tracking-wide uppercase">
                  {pack.title}
                </p>
                <p className="text-sm flex w-full justify-center items-center gap-2 md:text-base">
                  {!user ? (
                    <img
                      src="/images/header/win.svg"
                      alt=""
                      className="h-4 w-4"
                    />
                  ) : (
                    <>
                      {user?.activeMode === "coins" ? (
                        <img
                          src="/images/header/win.svg"
                          alt=""
                          className="h-4 w-4"
                        />
                      ) : (
                        <img
                          src="/images/header/star.svg"
                          alt=""
                          className="h-4 w-4"
                        />
                      )}
                    </>
                  )}
                  {pack.price}
                </p>
              </div>

              <div className="flex justify-center">
                <button
                  onClick={() => onView(pack)}
                  disabled={isBuying}
                  className="mt-2 w-full max-w-30 mx-auto px-4 py-2 text-xs md:text-sm font-semibold tracking-wide uppercase bg-[#2B5AFF26] hover:bg-[#223052] disabled:opacity-60 text-[#DBFAFF] transition"
                >
                  {isBuying ? "PROCESSING..." : "VIEW NOW"}
                </button>
              </div>
            </div>
          </div>
        ))}
      </div>
    </section>
  );
};

export default PacksGrid;
