"use client";

import { User } from "@/constants/types";
import Image from "next/image";
import { useEffect, useState } from "react";

interface CardItem {
  id: string;
  name: string;
  price: string;
  series: string;
  image: string;
  quantity: number;
  rarity: string;
}

type Props = {
  card: CardItem | null;
  onClose: () => void; // parent me setDetailCard(null)
  setIsOpenCardModal: React.Dispatch<React.SetStateAction<boolean>>;
  setIsOpen: React.Dispatch<React.SetStateAction<boolean>>;
  isOpen: boolean;
  user: User;
};

export default function InventoryDetailDrawer({
  card,
  onClose,
  setIsOpenCardModal,
  setIsOpen,
  isOpen,

  user,
}: Props) {
  if (!card) return null;

  const handleClose = () => {
    setIsOpen(false);
    setTimeout(() => {
      onClose();
    }, 300);
  };

  return (
    <div
      className={`
    fixed inset-0 z-[999999] flex justify-end
    transition-opacity duration-300
    ${
      isOpen
        ? "opacity-100 pointer-events-auto"
        : "opacity-0 pointer-events-none"
    }
  `}
    >
      {/* BACKDROP */}
      <div
        onClick={handleClose}
        className={`
    absolute inset-0 bg-black/60
    transition-opacity duration-300
    ${isOpen ? "opacity-100" : "opacity-0 pointer-events-none"}
  `}
      />

      {/* PANEL */}
      <div
        className={`
          relative w-full max-w-md bg-[#10131B] h-full shadow-2xl
          transform transition-transform duration-500 ease-out
          ${isOpen ? "translate-x-0" : "translate-x-full"}
        `}
      >
        <div className="h-full overflow-y-auto px-6 pt-10 flex flex-col items-center text-center font-sofia">
          {/* back btn */}
          <button
            onClick={handleClose}
            className="self-start text-[10px] cursor-pointer px-3 py-1 bg-[var(--color-gray)] text-white font-bold"
          >
            &lt; BACK
          </button>

          {/* big card */}
          <div className="relative mb-6">
            <div className="w-[220px] h-[300px] mx-auto flex items-center justify-center">
              <Image
                src={card.image.replace("cardsimages", "cards/images")}
                alt={card.name}
                width={200}
                height={280}
                className="w-[160px] h-[240px] img-border-radius rotate-swing"
              />
            </div>
            <div className="absolute -bottom-4 left-1/2 -translate-x-1/2 px-4 py-1 rounded-full text-[#DBFAFF] bg-[#151B27] text-xs md:text-base 2xl:text-xl font-bold">
              {card.quantity}
            </div>
          </div>

          <div className="mt-2 text-xs md:text-base 2xl:text-3xl text-[var(--color-blue)] font-bold uppercase">
            {card.rarity}
          </div>
          <div className="mt-2 text-lg md:text-xl 2xl:text-3xl font-extrabold uppercase">
            {card.name}
          </div>
          <div className="mt-1 text-xl flex items-center gap-1 md:text-2xl font-extrabold text-white">
            {user?.activeMode === "coins" ? (
              <img src="/images/header/win.svg" alt="" className="h-4 w-4" />
            ) : (
              <img src="/images/header/star.svg" alt="" className="h-4 w-4" />
            )}
            {card.price.replace("$", "")}
          </div>
          {card.quantity > 1 && (
            <button
              onClick={() => {
                setIsOpen(false);
                setIsOpenCardModal(true);
              }}
              className="mt-6 px-6 py-2 border cursor-pointer border-[var(--color-gray)] text-[10px] md:text-lg"
            >
              VIEW ALL {card.quantity} CARDS
            </button>
          )}

          <div className="mt-5 text-[11px] uppercase text-[var(--color-slate)]">
            {card.series}
          </div>
        </div>
      </div>
    </div>
  );
}
