"use client";

import Image from "next/image";
import { useState } from "react";

type Brand = "magic" | "pokemon" | "lorcana";
type ChildTab = "all" | Brand;

type PackItem = {
  id: string;
  title: string;
  subtitle: string;
  brand: Brand;
};

type CardDrop = {
  id: string;
  title: string;
  subtitle: string;
  brand: Brand;
  date: string;
  price: number;
  image: string;
};

const BRAND_IMAGES: Record<Brand, string> = {
  magic: "/images/inventory/magic.svg",
  pokemon: "/images/inventory/pokemon.svg",
  lorcana: "/images/inventory/lorcana.svg",
};

// Base dummy pack data per brand
const PACKS_BY_BRAND: Record<Brand, PackItem[]> = {
  pokemon: Array.from({ length: 12 }).map((_, i) => ({
    id: `pkm-${i}`,
    title: "Scarlet & Violet",
    subtitle: "Journey Together",
    brand: "pokemon",
  })),
  magic: Array.from({ length: 12 }).map((_, i) => ({
    id: `mtg-${i}`,
    title: "Wilds of Eldraine",
    subtitle: "Draft Booster",
    brand: "magic",
  })),
  lorcana: Array.from({ length: 12 }).map((_, i) => ({
    id: `lor-${i}`,
    title: "Rise of the Floodborn",
    subtitle: "Booster Pack",
    brand: "lorcana",
  })),
};

// Split items into N columns
const buildColumns = (items: PackItem[], cols: number): PackItem[][] => {
  const columns: PackItem[][] = Array.from({ length: cols }, () => []);
  items.forEach((item, index) => {
    columns[index % cols].push(item);
  });
  return columns;
};

import DetailSidebar from "../fairness/DetailSidebar";
import { User } from "@/constants/types";
import { useSelector } from "react-redux";

const OddsContent = () => {
  const [childTab, setChildTab] = useState<ChildTab>("all");
  const [detailCard, setDetailCard] = useState<CardDrop | null>(null);
  const user = useSelector((state: any) => state.auth.user) as User | null;
  const status = useSelector((state: any) => state.auth.status);

  const items: PackItem[] =
    childTab === "all"
      ? (Object.values(PACKS_BY_BRAND).flat() as PackItem[])
      : PACKS_BY_BRAND[childTab];

  const columns = buildColumns(items, 4);

  return (
    <>
      {/* Child tabs (brands) */}
      <div className="flex flex-wrap gap-2 mt-4 2xl:gap-4">
        <button
          onClick={() => setChildTab("all")}
          className={`px-4 md:px-6 py-2 md:py-3 font-extrabold transition-all text-xs 2xl:text-lg bg-[var(--color-naviBlue)] border-b-4 font-sofia border-transparent md:text-base ${
            childTab === "all"
              ? " text-white !border-[var(--color-blue)]"
              : "text-[var(--color-slate)] hover:bg-gray-700/50 opacity-60"
          }`}
        >
          ALL BRANDS
        </button>

        <button
          onClick={() => setChildTab("magic")}
          className={`px-4 md:px-6 py-2 md:py-3 font-extrabold transition-all text-xs 2xl:text-lg bg-[var(--color-naviBlue)] border-b-4 font-sofia border-transparent md:text-base ${
            childTab === "magic"
              ? " text-white !border-[var(--color-blue)]"
              : "text-[var(--color-slate)] hover:bg-gray-700/50 opacity-50"
          }`}
        >
          <span className="flex items-center gap-2">
            <Image
              width={117}
              height={37}
              src={BRAND_IMAGES.magic}
              alt="magic"
              className="w-12 md:w-[117px]"
            />
          </span>
        </button>

        <button
          onClick={() => setChildTab("pokemon")}
          className={`px-4 md:px-6 py-2 md:py-3 font-extrabold transition-all text-xs 2xl:text-lg bg-[var(--color-naviBlue)] border-b-4 font-sofia border-transparent md:text-base ${
            childTab === "pokemon"
              ? " text-white !border-[var(--color-blue)]"
              : "text-[var(--color-slate)] hover:bg-gray-700/50 opacity-50"
          }`}
        >
          <Image
            width={117}
            height={37}
            src={BRAND_IMAGES.pokemon}
            alt="pokemon"
            className="w-12 md:w-[117px]"
          />
        </button>

        <button
          onClick={() => setChildTab("lorcana")}
          className={`px-4 md:px-6 py-2 md:py-3 font-extrabold transition-all text-xs 2xl:text-lg bg-[var(--color-naviBlue)] border-b-4 font-sofia border-transparent md:text-base ${
            childTab === "lorcana"
              ? " text-white !border-[var(--color-blue)]"
              : "text-[var(--color-slate)] hover:bg-gray-700/50 opacity-50"
          }`}
        >
          <Image
            width={117}
            height={37}
            src={BRAND_IMAGES.lorcana}
            alt="lorcana"
            className="w-12 md:w-[117px]"
          />
        </button>
      </div>

      <section className="mt-6">
        <div className="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-4 gap-4 2xl:gap-8">
     {columns.map((col, colIndex) => (
  <div
    key={colIndex}
    className="bg-[var(--color-naviBlue)] px-4 py-4 border border-[var(--color-gray)]"
  >
    {col.map((pack) => {
      const isSelected = detailCard?.id === pack.id; // check if this card is selected

      return (
        <div
          key={pack.id}
          onClick={() => {
            const cardDrop: CardDrop = {
              id: pack.id,
              title: pack.title,
              subtitle: pack.subtitle,
              brand: pack.brand,
              date: "2024-01-01", // dummy
              price: 4.99, // dummy
              image: "/images/inventory/pokemon-pack.png",
            };
            setDetailCard(cardDrop);
          }}
          className={`flex items-center gap-4 px-3 py-3 cursor-pointer 
            hover:bg-[var(--color-black)]
            ${isSelected ? "bg-[var(--color-black)]" : ""}`}
        >
          <div className="w-10 h-16 flex items-center justify-center overflow-hidden bg-black/40">
            <Image
              src="/images/fairness/img.svg"
              alt={pack.title}
              width={60}
              height={96}
              className="object-contain"
            />
          </div>
          <div>
            <p className="font-onest font-normal text-xs md:text-sm ">
              {pack.title}
            </p>
            <p className="font-onest font-normal text-xs md:text-sm ">
              {pack.subtitle}
            </p>
          </div>
        </div>
      );
    })}
  </div>
))}

        </div>
      </section>

      <DetailSidebar card={detailCard} onClose={() => setDetailCard(null)} />
    </>
  );
};

export default OddsContent;
