"use client";
import { setUser } from "../../store/authSlice";
import { useRouter } from "next/navigation";
import { useEffect, useRef } from "react";
import Image from "next/image";
import { useAppDispatch } from "@/app/lib/hooks";

// import { ethers } from "ethers";

type Props = {
  open: boolean;
  onClose: () => void;
  onGoogle: () => void;
  onMetamask: () => void;
  onAppleLogin: () => void;
};

export default function AuthModal({
  open,
  onClose,
  onGoogle,
  onMetamask,
  onAppleLogin,
}: Props) {
  const dialogRef = useRef<HTMLDivElement>(null);
  const dispatch = useAppDispatch();
  const router = useRouter();

  const handleLogin = async () => {
    const user = {
      id: "1",
      name: "Demo User",
      email: "demo@example.com",
      userId: "",
      token: "",
      uuid: "string",
      join_date: "string",
      image: "",
      balance: 0,
      coins: 0,
      gems: 0,
      tickets: 0,

      level: { lavel: 0, xp: "0", next: 0 },
      is_deposit: false,
      is_kyc_verified: "no",
      activeMode: "normal",
      settings: {
        brand: "",
        theme: "",
        effect: "",
        sound: "",
        speed: "",
        mode: "",
      },
    };

    dispatch(setUser(user));

    router.replace("/dashboard");
  };
  // Close on ESC
  useEffect(() => {
    if (!open) return;
    const onKey = (e: KeyboardEvent) => e.key === "Escape" && onClose();
    window.addEventListener("keydown", onKey);
    return () => window.removeEventListener("keydown", onKey);
  }, [open, onClose]);

  if (!open) return null;

  return (
    <div
      className="fixed inset-0 !z-9999999999 flex items-center justify-center bg-black/70 backdrop-blur-sm p-4"
      onMouseDown={(e) => {
        // click outside to close
        if (e.target === e.currentTarget) onClose();
      }}
      aria-modal="true"
      role="dialog"
    >
      <div
        ref={dialogRef}
        className="w-full max-w-[520px] 2xl:max-w-[620px] font-onest rounded-2xl bg p-3 md:p-5 2xl:p-8 text-white border border-white/10 shadow-2xl"
      >
        {/* header row with close */}
        <div className="relative p-5">
          {/* OTP logo */}
          <div className="mx-auto flex justify-center">
            <Image
              src="/images/footer/footerLogo.svg"
              alt="Open That Pack"
              width={120}
              height={36}
              className="opacity-90"
            />
          </div>

          {/* close button */}
          <button
            onClick={onClose}
            aria-label="Close"
            className="absolute -right-4 -top-4 2xl:-right-3 p-4 hover:scale-105 duration-300 transition-all cursor-pointer"
          >
            <img src="/images/auth/modal/close.png" alt="" />
          </button>
        </div>

        <div className=" lg:pb-8">
          <p className="text-center text-xs md:text-xl font-extrabold font-sofia tracking-tight text-white/80">
            SIGN UP OR LOGIN WITH JUST ONE CLICK
          </p>

          {/* Buttons */}
          <div className="mt-6 grid gap-4">
            {/* Google */}
            <button
              onClick={onGoogle}
              className="h-12 w-full cursor-pointer hover:bg-[var(--color-hoverBlue)] transition-all duration-300 bg-[var(--color-blue)]  text-white font-medium flex items-center justify-center gap-3"
            >
              <Image
                src="/images/auth/modal/google.png"
                alt=""
                width={18}
                height={18}
              />
              <span className="text-xs md:text-base">Sign up with Google</span>
            </button>

            {/* Apple */}
            <button
              onClick={onAppleLogin}
              className="h-12 w-full cursor-pointer bg-white  hover:bg-[var(--color-hoverWhite)] duration-300 text-black  flex items-center justify-center gap-3"
            >
              <Image
                src="/images/auth/modal/apple.png"
                alt=""
                width={18}
                height={18}
              />
              <span className="text-xs md:text-base">
                Sign up with Apple ID
              </span>
            </button>

            {/* Metamask */}
            <button
              onClick={onMetamask}
              className="h-12 w-full cursor-pointer rounded-sm bg-transparent border duration-300 border-[var(--color-gray)] hover:border-[var(--color-hoverWhite)] text-white flex items-center justify-center gap-3"
            >
              <Image
                src="/images/auth/modal/meta.png"
                alt=""
                width={18}
                height={18}
              />
              <span className="text-xs md:text-base">
                Sign up with Metamask
              </span>
            </button>
            {/* <button
              onClick={handleLogin}
              className="px-4 py-2 bg-blue-600 rounded"
            >
              Fake Login
            </button> */}
          </div>

          {/* Social icons row */}
          <div className="mt-4 md:mt-7 flex items-center justify-center gap-4">
            <img
              src="/images/auth/modal/x2.svg"
              alt="social"
              className="w-10 lg:w-auto hover:scale-105 cursor-pointer duration-300 transtion-all"
            />
            <img
              src="/images/auth/modal/yt2.svg"
              alt="social"
              className="w-10 lg:w-auto hover:scale-105 cursor-pointer duration-300 transtion-all"
            />
            <img
              src="/images/auth/modal/tiktok.svg"
              alt="social"
              className="w-10 lg:w-auto hover:scale-105 cursor-pointer duration-300 transtion-all"
            />
          </div>

          {/* Terms */}
          <p className="mt-3 text-center text-xs md:text-base leading-5 text-white">
            By creating an account you are verifying that you are
            <br />
            above 18 and agree to{" "}
            <a href="#" className="underline hover:text-white">
              Terms &amp; services
            </a>{" "}
            and{" "}
            <a href="#" className="underline hover:text-white">
              Privacy Policy
            </a>
            .
          </p>
        </div>
      </div>
    </div>
  );
}

function SocialIcon({ src, alt }: { src: string; alt: string }) {
  return (
    <span className="grid h-9 w-9 place-items-center rounded-full border border-white/15 bg-white/5 hover:bg-white/10">
      <Image src={src} alt={alt} width={18} height={18} />
    </span>
  );
}
