"use client";
import { useEffect, useState } from "react";
import TradeCard from "./TradeCard";
import { fetchHomeMarket } from "@/app/lib/api/trade";

export type TradeProps = {
  name: string;
  rarity: string;
  probability: string;
  market_price: string;
  image: string;
  user: string;
  user_image: string;
  ago: string;
};

const TradePulls = () => {
  const [trades, setTrades] = useState<TradeProps[]>([]);
  const [isLoadingTrade, setIsLoadingTrade] = useState(false);
  const getTrade = async () => {
    setIsLoadingTrade(true);
    try {
      const res = await fetchHomeMarket();
      if (res.resp === "success") {
        setTrades(res.data);
      }
      setIsLoadingTrade(false);
    } catch (e: any) {
      console.log("error", e);
    }
  };
  useEffect(() => {
    getTrade();
  }, []);
  return (
    <div className="mt-5 bg-trade-pulls  overflow-hidden px-4 md:px-0 py-4 ">
      <div className=" container mx-auto p-5 mt-4 flex items-center flex-col md:flex-row gap-4 justify-between w-full">
        <div className="flex flex-col gap-3">
          <h1 className="font-sofia italic font-bold text-base md:text-2xl 2xl:text-2xl">
            VIRTUALLY OPEN PACKS,
          </h1>
          <h1 className="font-sofia italic font-bold text-base md:text-2xl -mt-4 2xl:text-2xl">
            GET REAL CARDS
          </h1>

          <button className="bg-[#4D4CFE] transistion-all duration-300 hover:bg-[var(--color-hoverBlue)] mt-5 font-onest font-semibold text-xs md:text-sm 2xl:text-base py-2 px-10 ">
            Shop Packs
          </button>
        </div>

        <div className="flex flex-col md:flex-row relative gap-3 items-center">
          {trades.map((trade, index) => (
            <TradeCard key={index} trade={trade} />
          ))}
        </div>
      </div>
    </div>
  );
};

export default TradePulls;
