"use client";
import { User } from "@/constants/types";
import Image from "next/image";
import { useSelector } from "react-redux";
import { TradeProps } from "./TradePulls";
type TradeCardProps = {
  trade: TradeProps;
};
const TradeCard = ({ trade }: TradeCardProps) => {
  const user = useSelector((state: any) => state.auth.user) as User | null;
const status = useSelector((state: any) => state.auth.status);

  return (
    <div
      className={`relative min-w-57.5 group bg-(--color-naviBlue) cursor-pointer animated-border border border-[#151C29] px-4 pt-4 pb-6 flex flex-col items-center duration-300 transtion-all  transition-all `}
    >
      {/* Top row: avatar, player, time */}
      <div className="flex relative z-20 w-full border-b border-[#29313D] pb-2 items-center justify-between mb-4 text-[10px] md:text-xs font-sofia ">
        <div className="flex items-center gap-2">
          <div className="h-6 w-6 rounded-full overflow-hidden bg-yellow-400 flex items-center justify-center">
            <Image
              src={
                trade?.user_image
                  ? `/cards/${trade?.user_image}`
                  : "/images/trade/profile.svg"
              }
              alt={trade?.user}
              width={24}
              height={24}
              className="object-cover"
            />
          </div>
          <span className="font-extrabold md:text-base ">{trade?.user}</span>
        </div>
        <span className="text-(--color-slate) md:text-base">{trade?.ago}</span>
      </div>

      {/* Card image */}
      <div className="w-20 relative z-20 h-24 2xl:w-27.5 2xl:h-38.25">
        <Image
          src={
            trade?.image ? `/cards/${trade?.image}` : "/images/home/img4.svg"
          }
          width={110}
          height={153}
          alt="{card.name}"
          className="w-full h-full group-hover:rotate-3 transition-all object-contain transform duration-500"
        />
      </div>

      {/* Text under image */}
      <div className="mt-2 relative z-20 text-center">
        <p className="text-[10px] md:text-base font-sofia text-[#DBFAFF] mb-1">
          {trade?.name}
        </p>
        <p className="text-sm md:text-xl font-extrabold font-sofia">
          {trade?.rarity}
        </p>
      </div>

      {/* Price button */}
      <button className="mt-3 flex items-center gap-2 rounded-md bg-[#2B5AFF26] z-20 px-6 py-1 text-sm md:text-xl font-extrabold text-[#DBFAFF] font-sofia">
        {!status ? (
          <img src="/images/header/win.svg" alt="" className="h-4 w-4" />
        ) : (
          <>
            {user?.activeMode === "coins" ? (
              <img src="/images/header/win.svg" alt="" className="h-4 w-4" />
            ) : (
              <img src="/images/header/star.svg" alt="" className="h-4 w-4" />
            )}
          </>
        )}
        <span>{trade?.market_price}</span>
      </button>
    </div>
  );
};

export default TradeCard;
