import Image from "next/image";
import { useState } from "react";

export function RollSlider({
  img1,
  img2,
  img3,
}: {
  img1: string;
  img2: string;
  img3: string;
}) {
  // 🔴 default center index MUST match default translate
  const [activeIndex, setActiveIndex] = useState(2); // fire

  const items = [
    { src: img1 },
    { src: img2 },
    { src: img3 },
    { src: img1 },
    { src: img2 },
    { src: img3 },
  ];

  return (
    <div
      className="roll-slider relative w-full overflow-hidden"
      onMouseEnter={() => setActiveIndex(3)} // win becomes center
      onMouseLeave={() => setActiveIndex(2)} // fire back to center
    >
      <div className="min-h-44 h-full" />

      <div className="roll-track absolute 2xl inset-0 flex items-center">
        {items.map((it, i) => (
          <div
            key={i}
            className="roll-item flex w-20 shrink-0 items-center justify-center"
          >
            <Image
              src={it.src}
              alt=""
              width={320}
              height={320}
              className={`roll-img ${
                i === activeIndex
                  ? activeIndex === 2
                    ? "roll-active "
                    : "purple-roll-active"
                  : "roll-inactive "
              }`}
            />
          </div>
        ))}
      </div>
    </div>
  );
}
