"use client";
import { User } from "@/constants/types";
import React, { useState } from "react";
import { useSelector } from "react-redux";

const Header = () => {
  const user = useSelector((state: any) => state.auth.user) as User | null;
const status = useSelector((state: any) => state.auth.status);
  return (
    <div className="relative bg-[#161E2A] overflow-hidden scrollbar-hide p-5 md:pt-16 mt-4 flex items-center flex-col md:flex-row gap-4 justify-between w-full">
      <div
        className={`absolute md:text-[480px] 2xl:text-[600px] font-onest left-14 font-black text-black opacity-20 select-none `}
      >
        TCG
      </div>
      <div className="flex z-30 gap-3 md:gap-7 items-start">
        <div className="flex mb-7 flex-col gap-3">
          <h1 className="italic font-extrabold text-base md:text-3xl ">
            BET CARDS, WIN CARDS.
          </h1>
          <p className="max-w-[350px] text-[#54657E] leading-7 font-medium text-sm md:text-lg 2xl:text-2xl">
            Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do
            eiusmod tempor incididunt ut labore et.
          </p>
          {!user && (
            <button
              onClick={() => {
                document.body.classList.add("auth-attention");

                // optional: 3 sec baad auto remove
                setTimeout(() => {
                  document.body.classList.remove("auth-attention");
                }, 3000);
              }}
              className="bg-[#4D4CFE] transistion-all duration-300 hover:bg-(--color-hoverBlue) mt-3 md:mt-6 w-fit font-onest font-medium px-3 md:px-4 2xl:px-6 py-2.5 2xl:py-3"
            >
              One-click Login
            </button>
          )}
        </div>
      </div>
      <div className="flex relative -mb-14 items-center">
        <div className="absolute bottom-17 left-1/2 -translate-x-1/2 w-37.5 md:w-[470px] h-[200px] md:h-[250px] bg-[#2B5AFF] blur-3xl rounded-full opacity-50"></div>
        <img
          src="/images/mystery-packs/5.svg"
          className="w-16 md:w-20 object-contain -rotate-15 blur-[1px] z-10 absolute -left-10 -bottom-20 h-[236px]"
          alt=""
        />
        <img
          src="/images/home/1.png"
          className="w-16 md:w-20 object-contain z-10 absolute -right-10 blur-[1px] -rotate-15 bottom-36 h-[236px]"
          alt=""
        />
        <img
          src="/images/home/2.png"
          className="w-16 md:w-20 object-contain z-10 absolute left-7  blur-[1px] bottom-28 md:bottom-36 h-[236px]"
          alt=""
        />
        <img
          src="/images/mystery-packs/5.svg"
          className="w-16 md:w-20 object-contain rotate-55 blur-[1px] z-40 absolute right-0 -bottom-24 h-[236px]"
          alt=""
        />
        <img
          src="/images/home/img.svg"
          className="relative z-30 object-contain md:-mb-20 h-[236px] md:h-[336px]"
          alt=""
        />
      </div>
    </div>
  );
};

export default Header;
