// components/Home2/FreeShipping.tsx
import React from "react";
import { useSelector } from "react-redux";

const FreeShipping = () => {
  const chatOpen = useSelector((state) => state.ui.chatOpen);
  return (
    <div className="banner-container relative">
      <div className={`background-text ${chatOpen ? "chat-open" : ""}`}>
        FREE SHIPPING!
      </div>
      <div className="absolute bottom-5 left-1/2 -translate-x-1/2 w-20 md:w-222 hidden lg:block h-12.5 bg-(--color-pink) blur-3xl rounded-full opacity-30" />

      <div className="pointer-events-none absolute inset-x-0 z-50 bottom-0  md:h-15 !bg-gradient-to-t !from-[var(--color-black)] !via-[var(--color-black)]/80 !to-transparent" />

      <div className="max-w-262.5 relative z-30 mx-auto">
        <div className="flex items-center flex-col md:flex-row justify-between gap-3 font-extrabold mt-10">
          <div className="text-sm md:text-2xl 2xl:text-3xl">
            <h3>GET YOUR CARDS AT YOUR DOORSTEP</h3>
          </div>

          <div className="text-sm md:text-2xl 2xl:text-3xl">
            <h3>DUTY-FREE WITHDRAWLS</h3>
          </div>

          <div className="text-sm md:text-2xl 2xl:text-3xl">
            <h3>WORLDWIDE SHIPPING</h3>
          </div>
        </div>
      </div>
    </div>
  );
};

export default FreeShipping;
