"use client";

import { useState } from "react";
type FaqItem = {
  question: string;
  answer: string;
};

type FaqCategory = {
  id: string;
  title: string;
  items: FaqItem[];
};

const faqData: FaqCategory[] = [
  {
    id: "general",
    title: "GENERAL QUESTIONS",
    items: [
      {
        question: "What is Open That Pack?",
        answer:
          "Open That Pack is a virtual pack opening platform where you can open trading card packs online and receive the physical cards afterward.",
      },
      {
        question: "What is TCGWin?",
        answer:
          "You purchase a pack, watch it be opened on stream or via video, and then decide if you want the cards shipped or traded back.",
      },
      {
        question: "What is TCGWin?",
        answer:
          "We work with distributors and buy in bulk, which lets us offer packs at a lower cost while still remaining fully licensed.",
      },
      {
        question: "What is TCGWin",
        answer:
          "All packs are factory sealed and opened on camera. Orders and tracking are handled through our secure system.",
      },
    ],
  },
];
const Faqs = () => {
  // store `${categoryId}-${index}` for the currently open item
  const [openId, setOpenId] = useState<string | null>(null);

  const handleToggle = (id: string) => {
    setOpenId((prev) => (prev === id ? null : id));
  };
  return (
    <div className="container py-5 md:py-20 font-onest mx-auto px-4 md:px-0">
      <div className="mx-auto max-w-4xl px-4 sm:px-6 lg:px-8">
        {faqData.map((category) => (
          <div key={category.id} className="mb-10 sm:mb-12 lg:mb-16">
            {/* Category title */}
            <h2 className="mb-4 text-sm md:text-base font-extrabold tracking-tighter text-center mt-4 sm:mb-6">
              {category.title}
            </h2>

            <div className="space-y-2 rounded-md ">
              {category.items.map((item, idx) => {
                const id = `${category.id}-${idx}`;
                const isOpen = openId === id;

                return (
                  <div key={id} className="bg-[#161E2A]">
                    <button
                      type="button"
                      onClick={() => handleToggle(id)}
                      className="flex w-full items-center justify-between px-4 py-3 text-left text-[13px] font-medium  hover:bg-slate-800 sm:px-5 sm:py-3.5 sm:text-sm"
                      aria-expanded={isOpen}
                    >
                      <span className="pr-4">{item.question}</span>
                      <span className="ml-auto flex h-6 w-6 shrink-0 items-center justify-center border-slate-500 text-xs font-bold ">
                        {isOpen ? "−" : "+"}
                      </span>
                    </button>

                    {/* Answer */}
                    <div
                      className="overflow-hidden transition-all duration-300 ease-in-out"
                      style={{
                        maxHeight: isOpen ? "500px" : "0px",
                        opacity: isOpen ? 1 : 0,
                      }}
                    >
                      <div className="px-4 mt-5 pb-4 text-[13px] sm:px-5 sm:text-sm">
                        {item.answer}
                      </div>
                    </div>
                  </div>
                );
              })}
            </div>
          </div>
        ))}
      </div>
    </div>
  );
};

export default Faqs;
