import { User } from "@/constants/types";
import Link from "next/link";
import { useSelector } from "react-redux";
export function SquareButton({
  href,
  label,
  icon,
  className = "",
  ActiveIcon,
  active,
  onClick,
}: {
  href: string;
  label: string;
  icon?: string;
  className?: string;
  ActiveIcon?: string;
  active?: boolean;
  onClick?: () => void; // <-- add this
}) {
  const user = useSelector((state: any) => state.auth.user) as User | null;

  return (
    <Link
      href={href}
      onClick={onClick}
      className={`group inline-flex items-center gap-2 px-4 transition-all duration-300 ${user ? "h-13" : "py-2"}  font-sofia tracking-wide font-extrabold 
      ${active ? "text-white" : "text-white"}
      ${
        label === "Inventory"
          ? active
            ? "bg-[var(--color-pink)]" // active state
            : "light-black-bg hover:bg-(--color-pink)!" // hover
          : active
            ? "bg-[var(--color-blue)] text-white" // active
            : "light-black-bg hover:!bg-[var(--color-blue)]" // hover
      }
      ${className}
    `}
    >
      {/* --- Icon wrapper --- */}
      {icon && (
        <span className="relative  flex items-center justify-center">
          {/* Default Icon: hide when active */}
          <img
            src={icon}
            alt=""
            className={`w-full h-full object-contain transition-all duration-300
              ${active ? "opacity-0" : "opacity-100 group-hover:opacity-0"}
            `}
          />

          {/* Active / Hover Icon: show whenever active OR on hover */}
          {ActiveIcon && (
            <img
              src={ActiveIcon}
              alt=""
              className={`absolute inset-0 w-full h-full object-contain transition-all duration-300
                ${active ? "opacity-100" : "opacity-0 group-hover:opacity-100"}
              `}
            />
          )}
        </span>
      )}

      {/* --- Label --- */}
      <span
        className={`
          text-xs md:text-base 2xl:text-xl uppercase
          ${active ? "text-white" : ""}
        `}
      >
        {label}
      </span>
    </Link>
  );
}
