"use client";

type ProgressGlowBarProps = {
  value: number;
  max?: number;
  height?: number;
  label?: string; // "2500 XP"
  showLabel?: boolean; // <-- only show when parent wants it
  className?: string;
  user?: object | null;
};

export default function ProgressGlowBar({
  value,
  max = 100,
  height = 17,
  showLabel = false,
  label,
  className = "",
  user,
}: ProgressGlowBarProps) {
  // const pct = Math.max(0, Math.min(100, (value / max) * 100));
  // const knob = Math.max(14, Math.min(20, Math.round(height * 0.8)));

  const pct = Math.max(0, Math.min(100, (value / max) * 100));
  const knob = Math.max(8, Math.min(16, Math.floor(height * 0.9)));

  const displayLabel = label ?? `${value} XP`;

  return (
    <div
      className={`relative w-full rounded-full
        bg-[linear-gradient(90deg,#162036_0%,#0c1322_100%)]
        border border-[#2B5AFF]/40
        shadow-[inset_0_0_0_1px_rgba(255,255,255,0.08)]
        overflow-hidden ${className}`}
      style={{ height }}
    >
      {/* fill */}
      <div
        className="absolute left-0 top-0  h-full rounded-full
        bg-[linear-gradient(90deg,#3D6BFF_0%,#2B5AFF_45%,#1D3FAF_100%)]"
        style={{ width: `${pct}%` }}
      />

      {/* ⭐ ONLY show text when parent uses showLabel */}
      {showLabel && (
        <div className="absolute inset-0 flex  items-center justify-center font-sofia text-lg md:text-xl text-white font-semibold pointer-events-none">
          {displayLabel}
        </div>
      )}

      {/* knob */}
      <div
        className="absolute top-1/2 -translate-y-1/2 rounded-full bg-white border border-white/70 shadow-[0_0_22px_8px_rgba(43,90,255,0.55)]"
        style={{
          width: knob,
          height: knob,
          left: `clamp(0px, calc(${pct}% - ${
            knob / 2
          }px), calc(100% - ${knob}px))`,
        }}
      />
    </div>
  );
}
