"use client";
import { User } from "@/constants/types";
import Link from "next/link";
import { useSelector } from "react-redux";

type Props = {
  href?: string;
  label: string;
  icon: string;
  ActiveIcon?: string;
  active?: boolean;
  emphasis?: boolean;
  hasDropdown?: boolean;
  onClick?: () => void;
};

export default function NavItem({
  href,
  label,
  icon,
  active,
  emphasis,
  ActiveIcon,
  hasDropdown,
  onClick,
}: Props) {
  const user = useSelector((state: any) => state.auth.user) as User | null;

  const className = `group  relative flex font-sofia font-extrabold text-xs md:text-base 2xl:text-xl uppercase items-center gap-1 transition-colors duration-200 ${
    active ? "text-white" : "text-gray-400 hover:text-white"
  }`;

  const content = (
    <>
      <span className="relative w-3.5 h-3.5 flex items-center justify-center">
        <img
          src={icon}
          alt={`${label} icon`}
          className={`w-full h-full object-contain transition-opacity duration-300 ${
            active ? "opacity-0" : "opacity-100 group-hover:opacity-0"
          }`}
        />
        {ActiveIcon && (
          <img
            src={ActiveIcon}
            alt={`${label} active icon`}
            className={`absolute inset-0 w-full h-full object-contain transition-opacity duration-300 ${
              active ? "opacity-100" : "opacity-0 group-hover:opacity-100"
            }`}
          />
        )}
      </span>

      <span className={`${emphasis ? "text-white font-semibold" : ""}`}>
        {label}
      </span>
      {hasDropdown && (
        <img
          src="/images/header/arrow.svg"
          alt="dropdown arrow"
          className={`
      ml-1 w-2 h-2
      transition-transform duration-200
      ${active ? "rotate-180" : ""}
      group-hover:rotate-180
    `}
        />
      )}
    </>
  );

  if (href) {
    return (
      <Link href={href} onClick={onClick} className={className}>
        {content}
        <span
          className={`
    absolute ${user ? "md:-bottom-6.5 2xl:-bottom-6" : "md:-bottom-5"}  hidden xl:block left-0 h-[2px] w-full bg-pink-500
    transition-all duration-200
    ${
      active
        ? "opacity-100 scale-x-100"
        : "opacity-0 scale-x-0 group-hover:opacity-100 group-hover:scale-x-100"
    }
  `}
        />
      </Link>
    );
  }

  return (
    <button type="button" onClick={onClick} className={className}>
      {content}
    </button>
  );
}
