import type { Metadata } from "next";

export const metadata: Metadata = {
  title: "About | Open That Pack",
  description: "Learn about Open That Pack and our mission.",
};

export default function AboutPage() {
  return (
    <section className="max-w-6xl mx-auto px-4 sm:px-6 py-12 md:py-16">
      <header className="mb-10">
        <h1 className="font-onest text-4xl md:text-5xl font-extrabold tracking-tight">
          About Us
        </h1>
        <p className="text-white/60 mt-3 max-w-2xl">
          We’re building the new ecosystem for trading-card investments — packs,
          games, sports, and rewards, all in one place.
        </p>
      </header>

      <div className="grid gap-8 md:grid-cols-2">
        <div className="rounded-2xl border border-white/10 p-6 bg-black/20">
          <h2 className="font-onest text-2xl font-semibold">Our Mission</h2>
          <p className="text-white/70 mt-3">
            To make trading cards investable and fun for everyone through slick
            UI, real-time markets, and fair pack opening.
          </p>
        </div>

        <div className="rounded-2xl border border-white/10 p-6 bg-black/20">
          <h2 className="font-onest text-2xl font-semibold">What We Do</h2>
          <ul className="mt-3 space-y-2 text-white/70 list-disc pl-5">
            <li>Packs & mystery boxes</li>
            <li>Sports & game experiences</li>
            <li>Marketplace and inventory</li>
            <li>XP, levels and rewards</li>
          </ul>
        </div>
      </div>

      <div className="mt-10 rounded-2xl border border-white/10 p-6 bg-black/20">
        <h2 className="font-onest text-2xl font-semibold">Contact</h2>
        <p className="text-white/70 mt-3">
          Questions? <a href="/contact" className="underline">Get in touch</a>.
        </p>
      </div>
    </section>
  );
}
